/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.generators.GameMapGenerator;
import technology.rocketjump.undermount.mapgen.generators.SequentialIdGenerator;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.input.RockType;
import technology.rocketjump.undermount.mapgen.model.input.ShrubType;
import technology.rocketjump.undermount.mapgen.model.input.TreeType;
import technology.rocketjump.undermount.mapgen.rendering.MapRenderer;
import technology.rocketjump.undermount.mapgen.rendering.camera.MapGenInputProcessor;
import technology.rocketjump.undermount.mapgen.rendering.camera.OnKeyUp;

public class MapGenApplicationAdapter
extends ApplicationAdapter
implements OnKeyUp {
    public static final float TIME_BETWEEN_UPDATES = 0.2f;
    private MapRenderer mapRenderer;
    private Random random;
    private GameMapGenerator mapGenerator;
    private MapGenInputProcessor inputProcessor;
    private float timeSinceLastUpdate = 0.0f;

    @Override
    public void create() {
        this.mapRenderer = new MapRenderer();
        this.inputProcessor = new MapGenInputProcessor(this);
        Gdx.input.setInputProcessor(this.inputProcessor);
        this.reset();
    }

    @Override
    public void render() {
        float deltaTime = Gdx.graphics.getDeltaTime();
        this.update(deltaTime);
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl.glClear(16384);
        this.mapRenderer.render(this.mapGenerator.getCurrentMap());
    }

    private void update(float deltaTime) {
        this.timeSinceLastUpdate += deltaTime;
        if (this.timeSinceLastUpdate > 0.2f) {
            this.timeSinceLastUpdate = 0.0f;
            this.mapGenerator.processNextStep();
        }
    }

    public void reset() {
        long seed = new RandomXS128().nextLong();
        System.out.println("Using seed " + seed);
        this.random = new RandomXS128(seed);
        OreType ironOre = new OreType("Iron Ore", new Color(0.6f, 0.1f, 0.1f, 1.0f), 1.0f);
        OreType coal = new OreType("Bituminous coal", new Color(0.1f, 0.1f, 0.1f, 1.0f), 2.3f);
        OreType nativeGold = new OreType("Native gold", new Color(1.0f, 1.0f, 0.1f, 1.0f), 0.3f);
        OreType tinOre = new OreType("Tin ore / cassiterite", new Color(0.8f, 0.9019608f, 1.0f, 1.0f), 0.3f);
        OreType nativeCopper = new OreType("Native copper", new Color(1.0f, 0.54901963f, 0.101960786f, 1.0f), 0.6f);
        OreType silverOre = new OreType("Silver ore / Galena", new Color(0.8f, 0.8f, 0.8f, 1.0f), 0.4f);
        OreType nativeSilver = new OreType("Native silver", new Color(0.91764706f, 0.91764706f, 0.91764706f, 1.0f), 0.4f);
        OreType copperOre = new OreType("Copper ore / Malachite", new Color(0.54901963f, 0.78431374f, 0.49411765f, 1.0f), 0.6f);
        RockType sandstone = new RockType(RockGroup.Sedimentary, "Sandstone", new Color(1.0f, 0.6f, 0.2f, 1.0f), 1.0f);
        sandstone.addOreType(ironOre, coal, tinOre);
        RockType limestone = new RockType(RockGroup.Sedimentary, "Limestone", new Color(1.0f, 1.0f, 0.9019608f, 1.0f), 2.0f);
        limestone.addOreType(ironOre, coal, tinOre);
        RockType shale = new RockType(RockGroup.Sedimentary, "Shale", new Color(0.3019608f, 0.09803922f, 0.09803922f, 1.0f), 1.0f);
        shale.addOreType(ironOre, coal, tinOre);
        RockType dolostone = new RockType(RockGroup.Sedimentary, "Dolostone", new Color(0.9529412f, 0.84705883f, 0.84705883f, 1.0f), 1.0f);
        dolostone.addOreType(ironOre, coal, tinOre);
        RockType granite = new RockType(RockGroup.Igneous, "Granite", new Color(0.3019608f, 0.3019608f, 0.3019608f, 1.0f), 4.0f);
        granite.addOreType(nativeGold, ironOre, nativeCopper, nativeSilver);
        RockType basalt = new RockType(RockGroup.Igneous, "Basalt", new Color(0.54901963f, 0.54901963f, 0.54901963f, 1.0f), 1.0f);
        basalt.addOreType(nativeGold, ironOre, nativeCopper);
        RockType marble = new RockType(RockGroup.Metamorphic, "Marble", new Color(0.9411765f, 0.9411765f, 0.9411765f, 1.0f), 1.0f);
        marble.addOreType(copperOre, silverOre);
        RockType slate = new RockType(RockGroup.Metamorphic, "Slate", new Color(0.54901963f, 0.54901963f, 0.54901963f, 1.0f), 1.0f);
        slate.addOreType(silverOre, copperOre);
        GemType amethyst = new GemType(RockGroup.Igneous, "Amethyst", new Color(0.9019608f, 0.15686275f, 0.9411765f, 1.0f), 1.0f);
        GemType rockCrystal = new GemType(RockGroup.Sedimentary, "Rock Crystal", new Color(0.98039216f, 0.98039216f, 0.98039216f, 1.0f), 1.0f);
        GemType emerald = new GemType(RockGroup.Metamorphic, "Emerald", new Color(0.11764706f, 1.0f, 0.27450982f, 1.0f), 1.0f);
        GameMapGenerationParams generationParams = new GameMapGenerationParams(320, 240);
        generationParams.addRockTypes(sandstone, limestone, shale, dolostone);
        generationParams.addRockTypes(granite, basalt);
        generationParams.addRockTypes(marble, slate);
        generationParams.addGemTypes(amethyst, rockCrystal, emerald);
        generationParams.getTreeTypes().add(new TreeType("Tree type A"));
        generationParams.getTreeTypes().add(new TreeType("Tree type B"));
        generationParams.getShrubTypes().add(new ShrubType("Non fruit A", false));
        generationParams.getShrubTypes().add(new ShrubType("Non fruit B", false));
        generationParams.getShrubTypes().add(new ShrubType("Fruit A", true));
        generationParams.getShrubTypes().add(new ShrubType("Fruit B", true));
        this.mapGenerator = new GameMapGenerator(generationParams, this.random);
        this.timeSinceLastUpdate = -1.0f;
        SequentialIdGenerator.reset();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void onKeyUp(int keycode) {
        if (keycode == 46) {
            this.reset();
        }
    }
}

